import { MSG, DEFAULT_SETTINGS } from "../shared/messages";
import type { ExtensionSettings } from "../shared/messages";

const enableToggle = document.getElementById("enableToggle") as HTMLInputElement;
const apiUrlInput = document.getElementById("apiUrl") as HTMLInputElement;
const clearCacheBtn = document.getElementById("clearCache") as HTMLButtonElement;
const cacheStatus = document.getElementById("cacheStatus") as HTMLSpanElement;

async function loadSettings(): Promise<void> {
  const result = await chrome.storage.local.get("settings");
  const settings: ExtensionSettings = result.settings ?? DEFAULT_SETTINGS;

  enableToggle.checked = settings.isEnabled;
  apiUrlInput.value = settings.apiUrl;
}

async function saveSettings(): Promise<void> {
  const settings: ExtensionSettings = {
    isEnabled: enableToggle.checked,
    apiUrl: apiUrlInput.value.trim() || DEFAULT_SETTINGS.apiUrl,
  };
  await chrome.storage.local.set({ settings });
}

enableToggle.addEventListener("change", saveSettings);

apiUrlInput.addEventListener("change", saveSettings);

clearCacheBtn.addEventListener("click", async () => {
  const response = await chrome.runtime.sendMessage({ type: MSG.CLEAR_CACHE });
  if (response?.success) {
    cacheStatus.textContent = `Cleared ${response.cleared} cached scans`;
    setTimeout(() => (cacheStatus.textContent = ""), 3000);
  }
});

loadSettings();
